﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;

using MEF_Interfejs; //IMessageSender

using TMetadata = System.Collections.Generic.IDictionary<string, object>;

namespace MEF_gospodarz
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();            
        }

        private void button1_Click(object sender, EventArgs e)
        {
            MefGospodarz gospodarz = new MefGospodarz();
            gospodarz.Compose();
            gospodarz.Run();
        }
    }

    class MefGospodarz
    {
        //[Import]
        //public IMessageSender MessageSender { get; set; }

        [ImportMany(typeof(IMessageSender))]
        //public IMessageSender[] MessageSenders { get; set; }
        public Lazy<IMessageSender, TMetadata>[] MessageSenders { get; set; }

        public void Compose()
        {
            AggregateCatalog katalog = new AggregateCatalog();
            katalog.Catalogs.Add(new DirectoryCatalog(@".\Wtyczki"));

            if (katalog.Parts.Count() > 0)
            {
                //wyświetlenie listy znalezionych wtyczek
                var kolekcja = katalog.Parts;
                string s = "Znalezione wtyczki:\n";
                foreach (var element in kolekcja) s += element.ToString() + "\n";
                MessageBox.Show(s);

                CompositionContainer pojemnik = new CompositionContainer(katalog);
                pojemnik.ComposeParts(this);
            }
        }

        public void Run()
        {
            //MessageSender.Send("Treść wiadomości");
            if (MessageSenders != null && MessageSenders.Count() > 0)
            {
                foreach (var element in MessageSenders)
                {
                    if ((bool)element.Metadata["CzyUzywaSieci"] == true) continue;
                    if (!element.Value.Send("Treść wiadomości"))
                        MessageBox.Show("Nie udało się dostarczyć wiadomości");
                }
            }
            else MessageBox.Show("Brak wtyczki pozwalającej na dostarczenie wiadomości");
        }
    }
}
